/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.console.info;

import filenet.sim.toolkit.console.IVWSIMConsoleStatusListener;
import filenet.sim.toolkit.console.VWSIMBaseNode;
import filenet.sim.toolkit.console.VWSIMConsoleActionCommand;
import filenet.sim.toolkit.console.VWSIMConsoleContextMenu;
import filenet.sim.toolkit.console.VWSIMConsoleStatusEvent;
import filenet.sim.toolkit.console.content.VWSIMListViewTableModel;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.IVWMouseActionListener;
import filenet.vw.toolkit.utils.VWMouseAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.table.TableColumn;

public class VWSIMConsoleSearchResultPane
extends JScrollPane
implements ActionListener,
IVWSIMConsoleStatusListener,
IVWMouseActionListener {
    private VWSIMListViewTableModel m_tableModel = null;
    private VWTable m_searchResultTable = null;
    private Vector m_searchResluts = new Vector();
    private VWMouseAdapter m_aMouseAdapter = null;

    public VWSIMConsoleSearchResultPane() {
        this.createSearchResultTable();
        this.setOpaque(true);
        this.getViewport().add(this.m_searchResultTable);
        this.m_aMouseAdapter = new VWMouseAdapter(this);
        this.m_searchResultTable.addMouseListener(this.m_aMouseAdapter);
    }

    public void addSearchResult(VWSIMBaseNode aNode) {
        this.m_searchResluts.add(aNode);
    }

    public void actionPerformed(ActionEvent event) {
        String actionCMD = event.getActionCommand();
        try {
            if (VWStringUtils.compare(actionCMD, VWSIMConsoleActionCommand.ACMD_CLEAR_SEARCH_RESULTS) == 0) {
                this.m_tableModel.clearAll();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void consoleStatusChanged(VWSIMConsoleStatusEvent evt) {
        VWSIMBaseNode baseNode = evt.getBaseNode();
        try {
            int statusType = evt.getType();
            if (statusType == 2) {
                int rowCount = this.m_tableModel.getRowCount();
                for (int i = rowCount - 1; i >= 0; --i) {
                    this.m_tableModel.removeRow(i);
                }
            } else if (!this.getStatusNode(baseNode)) {
                baseNode.setChangeEventStatus(statusType);
                this.m_tableModel.addRow(baseNode);
            }
            this.m_searchResultTable.updateUI();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void doubleClickedItem(MouseEvent event) {
    }

    public void createPopup(MouseEvent event) {
        try {
            if (this.m_tableModel.getRowCount() > 0) {
                VWSIMConsoleContextMenu mi = new VWSIMConsoleContextMenu(8, this);
                mi.show(event.getComponent(), event.getX(), event.getY());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void createSearchResultTable() {
        int nColWidth = 0;
        try {
            this.m_tableModel = new VWSIMListViewTableModel(this.m_searchResluts);
            this.m_searchResultTable = new VWTable(this.m_tableModel);
            this.m_searchResultTable.setRowSelectionAllowed(true);
            this.m_searchResultTable.setColumnSelectionAllowed(false);
            this.m_searchResultTable.setShowGrid(false);
            TableColumn aColumn = this.m_searchResultTable.getColumn(this.m_searchResultTable.getColumnName(2));
            try {
                nColWidth = Integer.valueOf("20");
            }
            catch (Exception ex) {
                nColWidth = 20;
            }
            aColumn.setMaxWidth(nColWidth);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private boolean getStatusNode(VWSIMBaseNode aNode) {
        int rowCount = this.m_tableModel.getRowCount();
        String name = aNode.getName();
        String docID = aNode.getDocID();
        boolean bFound = false;
        for (int i = 0; i < rowCount; ++i) {
        }
        return bFound;
    }

    protected void releaseResources() {
        if (this.m_searchResultTable != null) {
            this.m_searchResultTable.removeAll();
            this.m_searchResultTable = null;
        }
        this.m_tableModel = null;
        if (this.m_searchResluts != null) {
            this.m_searchResluts.removeAllElements();
            this.m_searchResluts = null;
        }
        if (this.m_aMouseAdapter != null) {
            this.m_aMouseAdapter.removeReferences();
            this.m_aMouseAdapter = null;
        }
        this.removeAll();
    }
}

